/*
 * Decompiled with CFR 0.152.
 */
package com.hisroyalty.block;

import com.hisroyalty.GachaMachine;
import com.hisroyalty.block.GachaMachineBlockEntity;
import com.hisroyalty.config.DatapackConfig;
import com.mojang.brigadier.Message;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class GachaMachineBlock
extends class_2237 {
    public static final class_2753 FACING = class_2383.field_11177;
    public static final class_2754<class_2756> HALF = class_2741.field_12533;
    private final class_6862<class_1792> currencyTag;
    private final String loot;
    private final int configProperty;

    public GachaMachineBlock(class_4970.class_2251 settings, class_6862<class_1792> currencyTag, String loot, int configProperty) {
        super(settings);
        this.currencyTag = currencyTag;
        this.loot = loot;
        this.configProperty = configProperty;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
        builder.method_11667(new class_2769[]{HALF});
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153())).method_11657(HALF, (Comparable)class_2756.field_12607);
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_11654(HALF) == class_2756.field_12609) {
            return;
        }
        if (!state.method_27852(newState.method_26204())) {
            class_2586 blockEntity = world.method_8321(pos);
            if (blockEntity instanceof GachaMachineBlockEntity) {
                world.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, world, pos, newState, moved);
        }
    }

    public static int deserializeLevel(int index) {
        return switch (index) {
            case 1 -> DatapackConfig.getMaxCurrency("gacha_machine_1");
            case 2 -> DatapackConfig.getMaxCurrency("gacha_machine_2");
            case 3 -> DatapackConfig.getMaxCurrency("gacha_machine_3");
            case 4 -> DatapackConfig.getMaxCurrency("gacha_machine_4");
            case 5 -> DatapackConfig.getMaxCurrency("gacha_machine_5");
            case 6 -> DatapackConfig.getMaxCurrency("gacha_machine_6");
            case 7 -> DatapackConfig.getMaxCurrency("gacha_machine_7");
            case 8 -> DatapackConfig.getMaxCurrency("gacha_machine_8");
            case 9 -> DatapackConfig.getMaxCurrency("gacha_machine_9");
            case 10 -> DatapackConfig.getMaxCurrency("gacha_machine_10");
            default -> 5;
        };
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return world.method_8320(pos.method_10084()).method_45474();
    }

    protected List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        if (state.method_11654(HALF) == class_2756.field_12609) {
            return Collections.emptyList();
        }
        return super.method_9560(state, builder);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        if (!world.method_8608()) {
            world.method_8652(pos.method_10084(), (class_2680)state.method_11657(HALF, (Comparable)class_2756.field_12609), 3);
        }
        super.method_9567(world, pos, state, placer, itemStack);
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 world, class_2338 pos, class_2338 neighborPos) {
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            boolean valid = true;
            class_2756 half = (class_2756)state.method_11654(HALF);
            if (!(half != class_2756.field_12607 || direction != class_2350.field_11036 || neighborState.method_27852((class_2248)this) && neighborState.method_11654(HALF) == class_2756.field_12609)) {
                valid = false;
            }
            if (!(half != class_2756.field_12609 || direction != class_2350.field_11033 || neighborState.method_27852((class_2248)this) && neighborState.method_11654(HALF) == class_2756.field_12607)) {
                valid = false;
            }
            if (!valid) {
                return class_2246.field_10124.method_9564();
            }
        }
        return super.method_9559(state, direction, neighborState, world, pos, neighborPos);
    }

    private boolean isValidItem(class_1799 stack, class_1937 world) {
        if (world.field_9236) {
            return false;
        }
        return stack.method_31573(this.currencyTag);
    }

    protected class_9062 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862;
        if (state.method_11654(HALF) == class_2756.field_12609) {
            pos = pos.method_10074();
        }
        if (!((class_25862 = world.method_8321(pos)) instanceof GachaMachineBlockEntity)) {
            return super.method_55765(stack, state, world, pos, player, hand, hit);
        }
        GachaMachineBlockEntity gachaMachineBlockEntity = (GachaMachineBlockEntity)class_25862;
        if (!this.isValidItem(stack, world)) {
            StringBuilder itemNames = new StringBuilder();
            List currencyItems = class_7923.field_41178.method_40260(this.currencyTag).method_40239().toList();
            if (currencyItems.isEmpty()) {
                itemNames.append("No valid currencies");
            } else {
                for (class_6880 itemRegistryEntry : currencyItems) {
                    class_1792 item = (class_1792)itemRegistryEntry.comp_349();
                    String itemName = item.method_7848().getString();
                    itemNames.append(itemName).append(", ");
                }
                if (!itemNames.isEmpty()) {
                    itemNames.setLength(itemNames.length() - 2);
                }
            }
            class_5250 message = class_2561.method_43469((String)"message.gacha_machine.invalid_currency", (Object[])new Object[]{class_2561.method_43470((String)itemNames.toString()).method_27694(style -> style.method_10977(class_124.field_1061))}).method_27694(style -> style.method_10977(class_124.field_1061));
            if (hand == class_1268.field_5808 && !player.method_37908().field_9236) {
                player.method_7353((class_2561)message, message.getString().length() <= 128);
            }
            return class_9062.field_47733;
        }
        if (this.isValidItem(stack, world)) {
            int currentLevel = gachaMachineBlockEntity.getLevel();
            if (currentLevel < GachaMachineBlock.deserializeLevel(this.configProperty) - 1) {
                gachaMachineBlockEntity.setLevel(currentLevel + 1);
                class_5250 text = class_2561.method_43470((String)"[").method_10852(class_2561.method_30163((String)String.valueOf(currentLevel + 1))).method_10852(class_2561.method_30163((String)"/")).method_10852(class_2561.method_30163((String)String.valueOf(GachaMachineBlock.deserializeLevel(this.configProperty)))).method_10852(class_2561.method_30163((String)"]"));
                if (!world.method_8608()) {
                    player.method_7353((class_2561)text, true);
                }
                if (!player.method_7337()) {
                    stack.method_7934(1);
                }
                class_3414 soundEvent = class_3417.field_24064;
                world.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
            } else if (!world.field_9236) {
                List<class_1799> capsules = this.getOutput(player);
                class_2350 direction = (class_2350)state.method_11654((class_2769)FACING);
                class_2338 spawnPos = pos;
                if (state.method_11654(HALF) == class_2756.field_12609) {
                    spawnPos = pos.method_10074();
                }
                double offsetX = (double)direction.method_10148() * 0.5;
                double offsetZ = (double)direction.method_10165() * 0.5;
                if (!player.method_7337()) {
                    stack.method_7934(1);
                }
                for (class_1799 capsule : capsules) {
                    if (capsule.method_7947() > 1) {
                        Random random = new Random();
                        int messageIndex = random.nextInt(4) + 1;
                        class_5250 message = class_2561.method_43469((String)("message.gacha_machine.multiple_rewards_" + messageIndex), (Object[])new Object[]{class_2561.method_54155((Message)capsule.method_7909().method_7848())}).method_27694(style -> style.method_10977(class_124.field_1065));
                        player.method_7353((class_2561)message, false);
                    }
                    class_1542 capsuleEntity = new class_1542(world, (double)spawnPos.method_10263() + 0.5 + offsetX, (double)spawnPos.method_10264() + 0.5, (double)spawnPos.method_10260() + 0.5 + offsetZ, capsule);
                    capsuleEntity.method_18800((double)direction.method_10148() * 0.2, 0.0, (double)direction.method_10165() * 0.2);
                    world.method_8649((class_1297)capsuleEntity);
                }
                gachaMachineBlockEntity.setLevel(0);
                world.method_8396(null, pos, class_3417.field_14627, class_3419.field_15245, 1.0f, 1.0f);
            }
            return class_9062.field_47728;
        }
        return class_9062.field_47733;
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof GachaMachineBlockEntity) {
            GachaMachineBlockEntity gachaMachineBlockEntity = (GachaMachineBlockEntity)class_25862;
            return gachaMachineBlockEntity.getLevel();
        }
        return 0;
    }

    public List<class_1799> getOutput(class_1657 player) {
        if (player == null) {
            System.err.println("Player is null");
            return List.of(class_1799.field_8037);
        }
        class_1937 class_19372 = player.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            System.err.println("Player is not in a server world");
            return List.of(class_1799.field_8037);
        }
        class_3218 serverWorld = (class_3218)class_19372;
        class_8567 parameters = new class_8567.class_8568(serverWorld).method_51874(class_181.field_24424, (Object)player.method_19538()).method_51874(class_181.field_1226, (Object)player).method_51875(GachaMachine.GACHA_MACHINE_LOOT_CONTEXT);
        class_2960 lootTableId = class_2960.method_60655((String)"gachamachine", (String)this.loot);
        class_52 lootTable = serverWorld.method_8503().method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)lootTableId));
        if (lootTable == null) {
            System.err.println("Loot table not found: " + String.valueOf(lootTableId));
            return List.of(class_1799.field_8037);
        }
        ObjectArrayList generatedLoot = lootTable.method_51878(parameters);
        if (generatedLoot == null || generatedLoot.isEmpty()) {
            System.err.println("No loot generated from table: " + String.valueOf(lootTableId));
            return List.of(class_1799.field_8037);
        }
        return generatedLoot;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new GachaMachineBlockEntity(pos, state);
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!(world.field_9236 || !player.method_7337() && player.method_7305(state))) {
            GachaMachineBlock.onBreakInCreative(world, pos, state, player);
        }
        return super.method_9576(world, pos, state, player);
    }

    protected static void onBreakInCreative(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2338 blockPos;
        class_2680 blockState;
        class_2756 doubleBlockHalf = (class_2756)state.method_11654(HALF);
        if (doubleBlockHalf == class_2756.field_12609 && (blockState = world.method_8320(blockPos = pos.method_10074())).method_27852(state.method_26204()) && blockState.method_11654(HALF) == class_2756.field_12607) {
            class_2680 blockState2 = blockState.method_26227().method_39360((class_3611)class_3612.field_15910) ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564();
            world.method_8652(blockPos, blockState2, 35);
            world.method_8444(player, 2001, blockPos, class_2248.method_9507((class_2680)blockState));
        }
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return null;
    }

    protected class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }
}

